package cn.com.duiba.scrm.common.param;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description 分页查询参数
 * @date ：Created in 2021/7/16
 */
public class ScrmPageQuery implements Serializable {

    private static final long serialVersionUID = -2061544361089581298L;
    /**
     * 查询页码 默认1 第一页
     */
    private int current = 1;
    /**
     * 查询条数 默认20条
     */
    private int pageSize = 20;

    private int offset;

    public ScrmPageQuery() {
    }

    public ScrmPageQuery(int current, int pageSize) {
        this.current = current;
        this.pageSize = pageSize;
    }

    public int getOffset() {
        offset = current >= 1 ? (current - 1) * pageSize : 0;
        return offset;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}
