/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static String getCookie(HttpServletRequest request, String key) {
        return RequestUtils.getCookies(request).get(key);
    }

    public static Map<String, String> getCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (Objects.isNull(cookies)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        for (Cookie c : cookies) {
            cookieMap.put(c.getName(), c.getValue());
        }
        return cookieMap;
    }

    public static String getLoginCookieValue(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        if ((SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv()) && StringUtils.isNotBlank((CharSequence)(value = request.getParameter(key)))) {
            return value;
        }
        return RequestUtils.getCookie(request, key);
    }

    public static Map<String, List<String>> getAllHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null || !headerNames.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            ArrayList valueList = new ArrayList();
            headers.put(name, valueList);
            Enumeration values = request.getHeaders(name);
            if (values == null || !values.hasMoreElements()) continue;
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
        }
        return headers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInputSteam(HttpServletRequest request) {
        try (ServletInputStream in = request.getInputStream();){
            int n;
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[1024];
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6RequestInputStream\u9519\u8bef", (Throwable)e);
            return "";
        }
    }
}

