package cn.com.duiba.scrm.common.enums;

import java.util.Arrays;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/19
 */
public enum SuiteMessageChangeTypeEnum {

    //成员通知事件
    CREATE_USER("create_user","新增成员",SuiteMessageInfoEnum.CHANGE_CONTACT),
    UPDATE_USER("update_user","更新成员",SuiteMessageInfoEnum.CHANGE_CONTACT),
    DELETE_USER("delete_user","删除成员",SuiteMessageInfoEnum.CHANGE_CONTACT),

    //部门通知事件
    CREATE_PARTY("create_party","新增部门",SuiteMessageInfoEnum.CHANGE_CONTACT),
    UPDATE_PARTY("update_party","更新部门",SuiteMessageInfoEnum.CHANGE_CONTACT),
    DELETE_PARTY("delete_party","删除部门",SuiteMessageInfoEnum.CHANGE_CONTACT),

    //标签通知事件
    UPDATE_TAG("update_tag","更新标签",SuiteMessageInfoEnum.CHANGE_CONTACT),

    //外部联系人事件
    ADD_EXTERNAL_CONTACT("add_external_contact","添加企业客户",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CONTACT),
    EDIT_EXTERNAL_CONTACT("edit_external_contact","编辑企业客户",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CONTACT),
    ADD_HALF_EXTERNAL_CONTACT("add_half_external_contact","外部联系人免验证添加成员事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CONTACT),
    DEL_EXTERNAL_CONTACT("del_external_contact","删除企业客户事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CONTACT),
    DEL_FOLLOW_USER("del_follow_user","删除跟进成员事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CONTACT),
    TRANSFER_FAIL("transfer_fail","客户接替失败事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CONTACT),

    //客户群事件
    GROUP_CREATE("create","客户群创建事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CHAT),
    GROUP_UPDATE("update","客户群变更事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CHAT),
    GROUP_DISMISS("dismiss","客户群解散事件",SuiteMessageInfoEnum.CHANGE_EXTERNAL_CHAT),

    //客户标签事件
    EXTERNAL_TAG_CREATE("create","企业客户标签创建",SuiteMessageInfoEnum.CHANGE_EXTERNAL_TAG),
    EXTERNAL_TAG_UPDATE("update","企业客户标签变更",SuiteMessageInfoEnum.CHANGE_EXTERNAL_TAG),
    EXTERNAL_TAG_DELETE("delete","企业客户标签删除",SuiteMessageInfoEnum.CHANGE_EXTERNAL_TAG),
    ;

    private String changeType;

    private String desc;

    /**
     * 上级消息枚举
     */
    private SuiteMessageInfoEnum suiteMessageInfoEnum;

    SuiteMessageChangeTypeEnum(String changeType,String desc,SuiteMessageInfoEnum suiteMessageInfoEnum){
        this.changeType = changeType;
        this.desc = desc;
        this.suiteMessageInfoEnum = suiteMessageInfoEnum;
    }

    public static SuiteMessageChangeTypeEnum getByChangeType(String changeType){
        for (SuiteMessageChangeTypeEnum suiteMessageChangeTypeEnum : SuiteMessageChangeTypeEnum.values()){
            if(suiteMessageChangeTypeEnum.getChangeType().equals(changeType)){
                return suiteMessageChangeTypeEnum;
            }
        }
        return null;
    }


    public String getChangeType() {
        return changeType;
    }

    public String getDesc() {
        return desc;
    }

    public SuiteMessageInfoEnum getSuiteMessageInfoEnum() {
        return suiteMessageInfoEnum;
    }
}

