package cn.com.duiba.scrm.common.enums.wechat;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/27
 */
public enum WelcomeMsgTypeEnum {

    /**
     * 素材
     */
    IMAGE("image", 2, "图片"),
    LINK("link", 3, "链接"),
    MINI_PROGRAM("miniprogram", 4, "小程序"),
    VIDEO("video", 5, "视频"),
    FILE("file", 6, "文件");

    private String type;
    private Integer code;
    private String desc;

    WelcomeMsgTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    WelcomeMsgTypeEnum(String type, Integer code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static WelcomeMsgTypeEnum getByCode(Integer code) {
        for (WelcomeMsgTypeEnum welcomeMsgTypeEnum : WelcomeMsgTypeEnum.values()) {
            if (welcomeMsgTypeEnum.getCode().equals(code)) {
                return welcomeMsgTypeEnum;
            }
        }
        return null;
    }
}
