package cn.com.duiba.scrm.common.enums.wechat;

import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 微信错误码
 * @author xiaotian
 * @date 2020-01-15
 */
@Slf4j
public enum WxErrorCodeEnum {
    E_10000("-10000","错误码暂时找不到对应"),
    //请求发生未知错误，可能已经成功，不可盲目重试
    E_8("-8","请求发送异常"),
    //确认请求未发出。可选择重试
    E_7("-7","httpclient 发送请求时错误"),
    //微信有些功能是下限不可用的，活着API中功能未开放
    E_6("-6","功能下线"),
    E_5("-5","参数错误"),
    //socket超时，但请求已经发出
    E_4("-4","请求没有回复"),
    //特殊情况
    E_3("-3","配置不发送消息"),
    E_2("-2","参数为空"),
    E_1("-1","系统繁忙，请开发者重试"),
    E0("0","请求成功"),
    E40014("40014","不合法的access_token"),
    E40029("40029","不合法的oauth_code"),
    E40098("40098","部分员工未实名认证"),
    E40099("40099","外部联系人的数量已达上限"),
    E40100("40100","此用户的外部联系人已经在转移流程中"),
    E40123("40123","上传临时图片素材，图片格式非法"),
    E40124("40124","推广活动里的sn禁止绑定"),
    E41037("41037","缺少「联系我」type参数"),
    E41038("41038","缺少「联系我」scene参数"),
    E41039("41039","无效的「联系我」type参数"),
    E41040("41040","无效的「联系我」scene参数"),
    E41041("41041","使用员工最多100人"),
    E41042("41042","无效的「联系我」style参数"),
    E41043("41043","缺少「联系我」config_id参数"),
    E41044("41044","该活码已失效"),
    E41045("41045","使用员工不得超过100个"),
    E41046("41046","缺少企业群发消息id"),
    E41047("41047","无效的企业群发消息id"),
    E41048("41048","无可发送的客户"),
    E41049("41049","缺少欢迎语code参数"),
    E41050("41050","无效的欢迎语code"),
    E41051("41051","客户和服务人员已经开始聊天了"),
    E41052("41052","无效的发送时间"),
    E41053("41053","客户未同意聊天存档"),
    E41054("41054","部分员工未激活"),
    E41055("41055","群欢迎语模板数量达到上限"),
    E41056("41056","外部联系人id类型不正确"),
    E41057("41057","企业或服务商未绑定微信开发者账号"),
    E41059("41059","缺少moment_id参数"),
    E41060("41060","不合法的moment_id参数"),
    E41061("41061","不合法朋友圈发送成员userid，当前朋友圈并非此用户发表"),
    E41062("41062","企业创建的朋友圈尚未被成员userid发表"),
    E41063("41063","群发消息正在被派发中，请稍后再试"),
    E41064("41064","附件大小超过限制"),
    E41065("41065","无效的附件类型"),
    E41066("41066","用户视频号名称错误"),
    E41067("41067","朋友圈moment_id类型错误"),
    E41102("41102","缺少菜单名"),
    E42001("42001","access_token已过期"),
    E42007("42007","pre_auth_code已过期"),
    E42009("42009","suite_access_token已过期"),
    E42012("42012","jsapi_ticket不可用，一般是没有正确调用接口来创建jsapi_ticket"),
    E42013("42013","小程序未登陆或登录态已经过期"),

    E60103("60103","手机号格式不正确")



    ;
    private String code;
    private String desc;

    WxErrorCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<String,WxErrorCodeEnum> valueMap = new HashMap<>();

    static {
        for (WxErrorCodeEnum value : WxErrorCodeEnum.values()) {
            valueMap.put(value.getCode(),value);
        }
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static WxErrorCodeEnum getByCode(String code){
        if(Objects.isNull(code)){
            return null;
        }
        WxErrorCodeEnum wxErrorCodeEnum = valueMap.get(code);
        if (Objects.isNull(wxErrorCodeEnum)){
            log.warn("wx error code miss {}",code);
            return WxErrorCodeEnum.E_10000;
        }
        return wxErrorCodeEnum;
    }


}
