package cn.com.duiba.scrm.common.result;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName RemoteResult.java
 * @Description quTui返回类
 * @createTime 2021年03月16日 17:49:00
 */
public class ScrmResult<T> implements Serializable {
    private Boolean success;
    private String code;
    private String desc;
    private T data;

    private ScrmResult(boolean success, T data, String desc) {
        this.success = success;
        this.desc = desc;
        this.data = data;
    }

    private ScrmResult(Boolean success, String code, String desc, T data) {
        this.success = success;
        this.code = code;
        this.desc = desc;
        this.data = data;
    }



    public static <T> ScrmResult<T> success(T t) {
        return new ScrmResult<>(true, t, "");
    }


    public static <T> ScrmResult<T> fail(String message) {
        return new ScrmResult<>(false, null, message);
    }

    public static <T> ScrmResult<T> fail(String code, String message) {
        return new ScrmResult<>(false, code, message, null);
    }

    public static <T> ScrmResult<T> getInstance(boolean success) {
        return new ScrmResult<>(success, null, null, null);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
