package cn.com.duiba.scrm.common.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * Created by zhangshun on 2019/1/31.
 */
public class NumberUtil {

    private NumberUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Integer parseInteger(String v, Integer defValue) {
        if (null == v) {
            return defValue;
        }
        if (StringUtils.isBlank(v)) {
            return defValue;
        }
        try {
            return Integer.parseInt(v);
        } catch (Exception e) {
            return defValue;
        }
    }

    public static Long parseLong(String v) {
        if (null == v) {
            return null;
        }
        String str = v;

        if (StringUtils.isBlank(str)) {
            return null;
        }
        return Long.parseLong(str);
    }

    public static Long parseLong(String v, Long defaultValue) {
        if (null == v) {
            return defaultValue;
        }
        String str = v;

        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        } catch (Exception e){
            return defaultValue;
        }
    }

    /**
     * 判读数字是否为空, 是否小于等于0
     * @return
     */
    public static boolean isNullOrLteZero(Long value) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (0 >= value.longValue()) {
            return true;
        }
        return false;
    }

    /**
     * 判读数字是否为空, 是否小于等于0
     * @return
     */
    public static boolean isNotNullOrLteZero(Long value) {
        return !isNullOrLteZero(value);
    }

    /**
     * 判读数字是否为空, 是否小于等于0
     * @return
     */
    public static boolean isNullOrLteZero(Integer value) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (0 >= value.intValue()) {
            return true;
        }
        return false;
    }

    /**
     * 判读数字是否为空, 是否小于等于0
     * @return
     */
    public static boolean isNotNullOrLteZero(Integer value) {
        return !isNullOrLteZero(value);
    }

    /**
     * 判读数字是否为空, 是否小于等于0
     * @return
     */
    public static boolean isNullOrLteZero(Float value) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (0 >= value.intValue()) {
            return true;
        }
        return false;
    }

    /**
     * 判读数字是否为空, 是否小于等于0
     * @return
     */
    public static boolean isNullOrLteZero(Double value) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (0 >= value.intValue()) {
            return true;
        }
        return false;
    }

}
