package cn.com.duiba.scrm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.dom4j.*;

import java.util.List;

/**
 * @author xiaotian
 * @date 2020/11/23 9:44 下午
 */
@Slf4j
public class Xml2JSONUtil {

    private Xml2JSONUtil(){}

    public static void main(String[] args) throws Exception {
        String xml = "<xml>\n" +
                "<ToUserName><![CDATA[appid]]></ToUserName>\n" +
                "<Encrypt><![CDATA[uh61qGXGuazikXCy4xE1bx/IWTuz6UbkW/2bSu2BgUPmA/SyAEfvOwblJiaSJ/AQIQa3rwZ9+owdfIqBiyVfYqnnRqmjJe1ekqQjjNxPjfETWWZIddqf7mnYf8aOn9AuAqPYv9bVOi64t/jKPZRP9EHdAZByGchSxMsTXTsjcZR4q+dUrF7Odkmum6HXOuhgRJb8izzCLHOIW4Oo540F5Hng8DJYbkd8N2lsV6dSfE75ZGWpJ4G/ZSO46cfmd7TzdvdaDU+7NJpP8BJO+Sc2+KyZcxg5vi1YMPsElEiQeZwMief9CcdpnZkJFK75QHk5t788zDmfQEHLU9l4MvBqOMlX5RN7Fdo3S/0B9w8TawVWMs9qv38J+jTBoxwm+vsBnz7HyYakXCW+VcwEpHBjB2PLovGRTNcMPyfuLFSQkuA0hUNpGV00BEmQcG7HTvuiQPLqvdiS7BHAawZCvsUs5A==]]></Encrypt>\n" +
                "</xml>";
        System.out.println(xml2Json(xml));
    }


    /**
     * xml转json
     * @param xml xml
     * @return json
     */
    public static JSONObject xml2Json(String xml){
        try {
            Document doc= DocumentHelper.parseText(xml);
            JSONObject json=new JSONObject();
            dom4j2Json(doc.getRootElement(), json);
            return json;
        }catch (DocumentException e) {
            log.error("parse xml to json has error ! xml={}",xml,e);
            return null;
        }
    }

    /**
     * xml转json
     * json再转 object
     * @param xml xml字符串
     * @param clazz clazz
     * @param <T> 对象
     * @return obj
     */
    public static <T> T xml2Object(String xml,Class<T> clazz){
        try {
            Document doc = DocumentHelper.parseText(xml);
            JSONObject json=new JSONObject();
            dom4j2Json(doc.getRootElement(), json);
            return json.toJavaObject(clazz);
        } catch (DocumentException e) {
            log.error("parse xml to object has error ! xml={} class={}",clazz.getSimpleName(),xml,e);
            return null;
        }
    }

    /**
     * xml转json
     * @param element
     * @param json
     */
    private static void dom4j2Json(Element element, JSONObject json){
        //如果是属性
        for(Object o:element.attributes()){
            Attribute attr=(Attribute)o;
            if(!isEmpty(attr.getValue())){
                json.put("@"+attr.getName(), attr.getValue());
            }
        }
        List<Element> chdEl=element.elements();
        if(chdEl.isEmpty()&&!isEmpty(element.getText())){//如果没有子元素,只有一个值
            json.put(element.getName(), element.getText());
        }

        for(Element e:chdEl){//有子元素
            if(!e.elements().isEmpty()){//子元素也有子元素
                JSONObject chdjson=new JSONObject();
                dom4j2Json(e,chdjson);
                Object o=json.get(e.getName());
                if(o!=null){
                    JSONArray jsona=null;
                    if(o instanceof JSONObject){//如果此元素已存在,则转为jsonArray
                        JSONObject jsono=(JSONObject)o;
                        json.remove(e.getName());
                        jsona=new JSONArray();
                        jsona.add(jsono);
                        jsona.add(chdjson);
                    }
                    if(o instanceof JSONArray){
                        jsona=(JSONArray)o;
                        jsona.add(chdjson);
                    }
                    json.put(e.getName(), jsona);
                }else{
                    if(!chdjson.isEmpty()){
                        json.put(e.getName(), chdjson);
                    }
                }


            }else{//子元素没有子元素
                for(Object o:element.attributes()){
                    Attribute attr=(Attribute)o;
                    if(!isEmpty(attr.getValue())){
                        json.put("@"+attr.getName(), attr.getValue());
                    }
                }
                if(!e.getText().isEmpty()){
                    json.put(e.getName(), e.getText());
                }
            }
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }
}
