package cn.com.duiba.scrm.common.enums.groupmsg;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 群发成员执行结果
 * @date 2021/7/30 20:28
 */
public enum GroupMsgSendResultEnum {

    /**
     * 群发成员执行结果
     */
    NOT_SEND(0, "未发送"),
    SEND(1, "已发送"),
    NOT_FRIEND(2, "因客户不是好友导致发送失败"),
    RECEIVED(3, "因客户已经收到其他群发消息导致发送失败")
    ;

    private final Integer type;
    private final String desc;

    GroupMsgSendResultEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static GroupMsgSendResultEnum getSendResult(Integer type) {
        for (GroupMsgSendResultEnum sendResultEnum : GroupMsgSendResultEnum.values()) {
            if (sendResultEnum.getType().equals(type)) {
                return sendResultEnum;
            }
        }
        return null;
    }
}
