package cn.com.duiba.scrm.common.factory;

/**
 * redis key
 */
public enum RedisKeyFactory {

    K001("企微应用accessToken"),
    K002("企微应用获取accessToken分布式锁"),
    K003("企微应用ticket"),
    K004("服务商accessToken"),
    K005("服务商获取accessToken分布式锁 "),
    K006("授权企业accessToken"),
    K007("授权企业获取accessToken分布式锁"),
    K008("同步企业成员分布式锁"),
    K009("同步企业群组分布式锁"),
    K010("同步企业标签分布式锁"),
    K011("上传微信素材mediaId缓存"),

    /**
     * 缓存、加锁都用同一个枚举，通过添加"lock"区分
     */
    K012("jsapi_ticket"),

    K013("同步群发任务的分布式缓存"),

    K014("员工信息缓存"),
    K015("企业信息缓存"),
    K016("员工角色信息缓存"),
    K017("应用信息数据缓存"),


    K018("数据导出"),

    K019("第三方应用授权状态刷新分布式锁"),
    K020("员工授权信息缓存"),

    K021("变更成员信息redis锁"),
    K022("变更客户信息redis锁"),
    K023("全量同步第三方授权redis锁"),
    K024("雷达数据总览历史数据"),

    ;

    private static final String SPACE = "SCRMCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc) {
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString() {
        return SPACE + SEPARATOR + this.name();
    }
}
