/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import cn.com.duiba.scrm.common.enums.crypto.IdConvertBase64Enum;
import cn.com.duiba.scrm.common.util.IdEncodeByBase64;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class IdMakerUtil {
    private IdMakerUtil() {
    }

    public static String encodingIdByBase64(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, IdConvertBase64Enum.DEF);
    }

    public static String encodingIdByBase64(Long id, IdConvertBase64Enum base64Enum) {
        if (Objects.isNull(id) || base64Enum == null) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, base64Enum);
    }

    public static Long decodingIdByBase64(String encode) {
        return IdEncodeByBase64.decodingId(encode);
    }

    public static Long decodingIdByBase64ForScid(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return IdMakerUtil.decodingIdByBase64(value);
    }

    public static Long decodingId(String encode) {
        return IdMakerUtil.decodingIdByBase64(encode);
    }

    public static Long compatibleDecodingId(String encode, Long compatibleId) {
        Long id = IdMakerUtil.decodingId(encode);
        if (Objects.isNull(id) && NumberUtils.isNumber((String)encode)) {
            id = Long.valueOf(encode);
            if (Objects.nonNull(compatibleId) && id > compatibleId) {
                return null;
            }
        }
        return id;
    }

    public static Long compatibleDecodingIdByBase64(String encode, Long compatibleId) {
        if (NumberUtils.isNumber((String)encode)) {
            Long id = Long.valueOf(encode);
            if (id < compatibleId || compatibleId == -1L) {
                return id;
            }
            return null;
        }
        return IdMakerUtil.decodingId(encode);
    }
}

