/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class NumberUtil {
    private NumberUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Integer parseInteger(String v, Integer defValue) {
        if (null == v) {
            return defValue;
        }
        if (StringUtils.isBlank((CharSequence)v)) {
            return defValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static Long parseLong(String v) {
        if (null == v) {
            return null;
        }
        String str = v;
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return Long.parseLong(str);
    }

    public static Long parseLong(String v, Long defaultValue) {
        if (null == v) {
            return defaultValue;
        }
        String str = v;
        if (StringUtils.isBlank((CharSequence)str)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isNullOrLteZero(Long value) {
        if (Objects.isNull(value)) {
            return true;
        }
        return 0L >= value;
    }

    public static boolean isNotNullOrLteZero(Long value) {
        return !NumberUtil.isNullOrLteZero(value);
    }

    public static boolean isNullOrLteZero(Integer value) {
        if (Objects.isNull(value)) {
            return true;
        }
        return 0 >= value;
    }

    public static boolean isNotNullOrLteZero(Integer value) {
        return !NumberUtil.isNullOrLteZero(value);
    }

    public static boolean isNullOrLteZero(Float value) {
        if (Objects.isNull(value)) {
            return true;
        }
        return 0 >= value.intValue();
    }

    public static boolean isNullOrLteZero(Double value) {
        if (Objects.isNull(value)) {
            return true;
        }
        return 0 >= value.intValue();
    }
}

