package cn.com.duiba.scrm.common.enums.groupmsg;

import org.apache.commons.lang3.StringUtils;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 群发任务类型
 * @date 2021/7/30 19:29
 */
public enum GroupMsgChatTypeEnum {

    /**
     * 群发任务类型
     */
    SINGLE("single", "发送给客户"),
    GROUP("group", "发送给客户群");

    /**
     * 参数
     */
    private final String param;
    /**
     * 描述
     */
    private final String desc;

    GroupMsgChatTypeEnum(String param, String desc) {
        this.param = param;
        this.desc = desc;
    }

    public String getParam() {
        return param;
    }

    public String getDesc() {
        return desc;
    }

    public static GroupMsgChatTypeEnum getChatType(String type) {
        for (GroupMsgChatTypeEnum chatTypeEnum : GroupMsgChatTypeEnum.values()) {
            if (StringUtils.equals(type, chatTypeEnum.getParam())) {
                return chatTypeEnum;
            }
        }
        return null;
    }
}
