package cn.com.duiba.scrm.common.enums.groupmsg;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: TODO
 * @date 2021/7/30 20:20
 */
public enum GroupMsgExecStatusEnum {

    /**
     * 群发任务执行情况
     */
    NOT_FINISH(0, "尚未执行完成"),
    FINISH(1, "全部执行完成");

    private final Integer type;
    private final String desc;

    GroupMsgExecStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static GroupMsgExecStatusEnum getExecStatus(Integer type) {
        for (GroupMsgExecStatusEnum execStatusEnum : GroupMsgExecStatusEnum.values()) {
            if (execStatusEnum.getType().equals(type)) {
                return execStatusEnum;
            }
        }
        return null;
    }
}
