package cn.com.duiba.scrm.common.enums.db.job;

import java.util.Objects;

/**
 * @author wangxukai
 * @description 任务规则类型
 * @date ：Created in 2021/9/8
 */
public enum JobRuleTypeEnum {
    REGULAR_TIME(1,"定时"),
    PERIOD_TIME(2,"周期");
    private Integer type;
    private String desc;
    JobRuleTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public static JobRuleTypeEnum getJobRuleTypeEnum(int type){
        for (JobRuleTypeEnum value : JobRuleTypeEnum.values()) {
            if (Objects.equals(value.getType(),type)){
                return value;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
