package cn.com.duiba.scrm.common.enums.db.pharse;

import org.apache.commons.lang3.StringUtils;

/**
 * @author wangxukai
 * @description 默认占用话术库分组名称
 * @date ：Created in 2021/9/24
 */
public enum DefaultGroupNameEnum {

    ALL("全部分组"),
    DEFAULT("默认分组");
    private String name;

    DefaultGroupNameEnum(String name){
        this.name = name;
    }

    /**
     * 检查重名
     * @param name
     * @return
     */
    public static boolean checkName(String name){
        if(StringUtils.isBlank(name)){
            return false;
        }
        for(DefaultGroupNameEnum groupNameEnum : values()){
            if (groupNameEnum.getName().equals(name)) {
                return false;
            }
        }
        return true;
    }

    public String getName() {
        return name;
    }
}
