package cn.com.duiba.scrm.common.enums.db.tag;

/**
 * @author xiaotian
 * @description 标签类型枚举
 * @date ：Created in 2021/08/25
 */
public enum TagTypeEnum {

    QIWEI(1,"企微客户标签"),
    CHAT_GROUP(2,"群标签")
   ;

    private Integer type;
    private String desc;
    TagTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public static TagTypeEnum getByType(Integer type){
        for (TagTypeEnum tagTypeEnum : TagTypeEnum.values()){
            if(tagTypeEnum.getType().equals(type)){
                return tagTypeEnum;
            }
        }
        return QIWEI;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
