package cn.com.duiba.scrm.common.mq;

import cn.com.duiba.scrm.common.annotation.mq.MqConsumerMethod;
import cn.com.duiba.scrm.common.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/**
 * @author wangxukai
 * @description 消费方法对象
 * @date ：Created in 2021/10/22
 */
public class ConsumerMethod {

    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);


    private Method method;

    private Object bean;

    private MqConsumerMethod annotation;



    public ConsumerMethod(Method method,Object bean,MqConsumerMethod annotation){
        this.method = method;
        this.bean = bean;
        this.annotation = annotation;
    }

    public Object invoke(String body){
        try {
            return this.method.invoke(this.bean,body);
        } catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.warn("MqConsumerMethod invoke error",e);
        }
        return null;
    }

    public Method getMethod() {
        return method;
    }

    public Object getBean() {
        return bean;
    }

    public MqConsumerMethod getAnnotation() {
        return annotation;
    }
}
