package cn.com.duiba.scrm.common.util;

import com.google.zxing.*;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import org.apache.commons.lang3.StringUtils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import static com.google.zxing.client.j2se.MatrixToImageConfig.BLACK;
import static com.google.zxing.client.j2se.MatrixToImageConfig.WHITE;
/**
 * @author wangxukai
 * @description 二维码相关操作
 * @date ：Created in 2021/7/28
 */
public class QrCodeUtil {


    /**
     * 字符串转二维码base64
     *
     * @param content
     * @return
     */
    public static String stringToBase64(String content, String headImg) throws WriterException, IOException {

        BufferedImage bufferedImage = codeAddHeadToImage(content,headImg);

        // 写到输出流
        ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, "png", outputStream1);

        //转换为base64
        Base64.Encoder encoder1 = Base64.getEncoder();
        return "data:image/jpeg;base64," + encoder1.encodeToString(outputStream1.toByteArray());
    }

    private static BufferedImage codeAddHeadToImage(String content, String headImg) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        // 指定编码格式
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        //设置白边
        hints.put(EncodeHintType.MARGIN, 0);

        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);

        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 600, 600, hints);

        BufferedImage bufferedImage = toBufferedImage(bitMatrix);

        if (StringUtils.isNotBlank(headImg)) {
            bufferedImage = logoMatrix(bufferedImage, headImg);
        }
        return bufferedImage;
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                image.setRGB(x, y, (matrix.get(x, y) ? BLACK : WHITE));
            }
        }
        return image;
    }

    public static void main(String[] args) throws IOException, WriterException, NotFoundException {
//        String content = "http://www.baidu.com";
//        System.out.println(QrCodeUtil.stringToBase64(content, "http://wx.qlogo.cn/mmopen/ibLButGMnqJMicfeAk8rDNFEPwwUBbr3CldCicZfDxjqZMFMBNmOun8v9lGRROlianibZFjPctWzHbP4u6gWNJI9gZ4n5emzNUrNw/0"));
        urlToLink("https://wework.qpic.cn/wwpic/381128_UddXPXhuSLaXwNm_1627385399/0");
    }


    public static BufferedImage logoMatrix(BufferedImage matrixImage, String logoUrl) throws IOException {
        /**
         * 读取二维码图片，并构建绘图对象
         */
        Graphics2D g2 = matrixImage.createGraphics();

        int matrixWidth = matrixImage.getWidth();
        int matrixHeigh = matrixImage.getHeight();

        /**
         * 读取Logo图片
         */
        BufferedImage logo = ImageIO.read(new URL(logoUrl));
        //开始绘制图片
        //绘制
        g2.drawImage(logo, matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, null);
        BasicStroke stroke = new BasicStroke(5, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND);
        // 设置笔画对象
        g2.setStroke(stroke);
        //指定弧度的圆角矩形
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, 20, 20);
        g2.setColor(Color.white);
        // 绘制圆弧矩形
        g2.draw(round);

        //设置logo 有一道灰色边框
        BasicStroke stroke2 = new BasicStroke(1, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND);
        // 设置笔画对象
        g2.setStroke(stroke2);
        RoundRectangle2D.Float round2 = new RoundRectangle2D.Float(matrixWidth / 5 * 2 + 2, matrixHeigh / 5 * 2 + 2, matrixWidth / 5 - 4, matrixHeigh / 5 - 4, 20, 20);
        g2.setColor(new Color(128, 128, 128));
        // 绘制圆弧矩形
        g2.draw(round2);

        g2.dispose();
        matrixImage.flush();
        return matrixImage;
    }

    /**
     * 二维码链接转为字符串
     * @param codeUrl
     * @return
     * @throws IOException
     * @throws NotFoundException
     */
    public static String urlToLink(String codeUrl) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(new URL(codeUrl));
        MultiFormatReader formatReader = new MultiFormatReader() ;
        LuminanceSource source = new BufferedImageLuminanceSource(image);
        Binarizer binarizer = new HybridBinarizer(source);
        BinaryBitmap binaryBitmap = new BinaryBitmap(binarizer);
        //图片 ->result
        Map map = new HashMap();
        map.put(EncodeHintType.CHARACTER_SET, "utf-8") ;
        Result result = formatReader.decode(binaryBitmap  ,map ) ;
        System.out.println("解析结果："+ result.toString());
        return result.toString();
    }

    /**
     * 二维码替换中间头像
     * @param codeUrl
     * @param headUrl
     * @return
     */
    public static BufferedImage codeAddHead(String codeUrl, String headUrl) throws IOException, NotFoundException, WriterException {
        return codeAddHeadToImage(urlToLink(codeUrl),headUrl);
    }

}
