/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.mq;

import cn.com.duiba.scrm.common.annotation.mq.MqConsumerMethod;
import cn.com.duiba.scrm.common.util.RequestUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerMethod {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);
    private Method method;
    private Object bean;
    private MqConsumerMethod annotation;
    private String env;

    public ConsumerMethod(Method method, Object bean, MqConsumerMethod annotation) {
        this.method = method;
        this.bean = bean;
        this.annotation = annotation;
    }

    public Object invoke(String body) {
        try {
            return this.method.invoke(this.bean, body);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.warn("MqConsumerMethod invoke error", (Throwable)e);
            return null;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getBean() {
        return this.bean;
    }

    public MqConsumerMethod getAnnotation() {
        return this.annotation;
    }
}

