/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.mq;

import cn.com.duiba.scrm.common.annotation.mq.MqConsumerMethod;
import cn.com.duiba.scrm.common.mq.ConsumerMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqConsumerManager {
    private static final Logger log = LoggerFactory.getLogger(MqConsumerManager.class);
    private static final Map<String, ConcurrentHashMap<String, List<ConsumerMethod>>> MQ_METHOD_MAP = new ConcurrentHashMap<String, ConcurrentHashMap<String, List<ConsumerMethod>>>();

    public static List<ConsumerMethod> get(String topic, String tag) {
        Map tagMqConsumerMap = MQ_METHOD_MAP.get(topic);
        if (tagMqConsumerMap == null) {
            return null;
        }
        return (List)tagMqConsumerMap.get(tag);
    }

    public static void put(ConsumerMethod method) {
        MqConsumerMethod annotation = method.getAnnotation();
        Map tagMqConsumerMap = MQ_METHOD_MAP.computeIfAbsent(annotation.topic().getTopicByEnv(), k -> new ConcurrentHashMap());
        List methods = tagMqConsumerMap.computeIfAbsent(annotation.tag().getTag(), k -> new ArrayList());
        methods.add(method);
    }
}

