/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ListSubIterator<T> {
    private List<T> list;
    private int pageSize;
    private int curIndex = 0;

    public ListSubIterator(List<T> list, int pageSize) {
        this.list = list;
        this.pageSize = pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean hasNext() {
        return this.pageSize > 0 && !CollectionUtils.isEmpty(this.list) && this.curIndex < this.list.size() && this.curIndex >= 0;
    }

    public List<T> next() {
        if (!this.hasNext()) {
            return new ArrayList();
        }
        int nextIndex = this.curIndex + this.pageSize;
        if (nextIndex > this.list.size()) {
            nextIndex = this.list.size();
        }
        List<T> result = this.list.subList(this.curIndex, nextIndex);
        this.curIndex = nextIndex;
        return result;
    }
}

