package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signcontract.SignBetTypeEnum;

import java.io.Serializable;
import java.util.Date;
/**
 * @author xiaoxuda on 2018/6/6.
 */
public class SignContractDto implements Serializable {
    private static final long serialVersionUID = 5454155825314635342L;

    /**
     * 自增主键 
     **/
    private Long id;
    /**
     * 活动名称 
     **/
    private String title;
    /**
     * 投注方式（1：自由额度，2：固定额度） 
     **/
    private SignBetTypeEnum betType;
    /**
     * 投注数量（固定额度时有效）
     **/
    private Long betCount;
    /**
     * 庄家奖励数量
     **/
    private Long bankerBonus;
    /**
     * 规则描述
     **/
    private String ruleDesc;
    /**
     * 契约周期
     **/
    private Integer contractCycle;
    /**
     * 参与时间限制，0：无限制，1：有限制
     **/
    private Boolean joinTimeLimit;
    /**
     * 参与实践限制起始时间，HH:mm
     **/
    private String joinTimeStart;
    /**
     * 参与实践限制最晚时间，HH:mm
     **/
    private String joinTimeEnd;
    /**
     * 开启开关，0：关闭，1：打开
     **/
    private Boolean openStatus;
    /**
     * 删除标记：0-否 1-是
     */
    private Boolean deleted;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SignBetTypeEnum getBetType() {
        return betType;
    }

    public void setBetType(SignBetTypeEnum betType) {
        this.betType = betType;
    }

    public Long getBetCount() {
        return betCount;
    }

    public void setBetCount(Long betCount) {
        this.betCount = betCount;
    }

    public Long getBankerBonus() {
        return bankerBonus;
    }

    public void setBankerBonus(Long bankerBonus) {
        this.bankerBonus = bankerBonus;
    }

    public String getRuleDesc() {
        return ruleDesc;
    }

    public void setRuleDesc(String ruleDesc) {
        this.ruleDesc = ruleDesc;
    }

    public Integer getContractCycle() {
        return contractCycle;
    }

    public void setContractCycle(Integer contractCycle) {
        this.contractCycle = contractCycle;
    }

    public Boolean getJoinTimeLimit() {
        return joinTimeLimit;
    }

    public void setJoinTimeLimit(Boolean joinTimeLimit) {
        this.joinTimeLimit = joinTimeLimit;
    }

    public String getJoinTimeStart() {
        return joinTimeStart;
    }

    public void setJoinTimeStart(String joinTimeStart) {
        this.joinTimeStart = joinTimeStart;
    }

    public String getJoinTimeEnd() {
        return joinTimeEnd;
    }

    public void setJoinTimeEnd(String joinTimeEnd) {
        this.joinTimeEnd = joinTimeEnd;
    }

    public Boolean getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Boolean openStatus) {
        this.openStatus = openStatus;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }
}

