package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.ReSignResultDto;
import cn.com.duiba.sign.center.api.dto.SignLogDto;
import cn.com.duiba.sign.center.api.dto.SignResultDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignStatusEnum;
import cn.com.duiba.sign.center.api.params.SignLogQueryParam;
import cn.com.duiba.sign.center.api.params.SignRequestParam;

import java.util.List;

/**
 * 签到流水
 * Created by xiaoxuda on 2017/5/31.
 */
@AdvancedFeignClient
public interface RemoteSignLogService {

    /**
     * 查询签到流水
     * @param logId
     * @return
     */
    SignLogDto findByLogId(Long logId);

    /**
     * 签到请求
     * 如果已存在当天的签到记录
     * 1.状态为失败则允许重试，创建新的签到流水
     * 2.状态不是失败，则返回签到失败结果，包含签到信息的当前状态
     * @param param
     * @return 重复签到时SignResult信息：success=false,message=SignCenterExCode.REPLAY_SUBMIT，logId=logId
     */
    SignResultDto createSignLog(SignRequestParam param) throws BizException;

    /**
     * 补签请求
     * 如果已存在当天的签到记录
     * 1.状态为失败则允许重试，创建新的签到流水
     * 2.状态不是失败，则返回签到失败结果，包含签到信息的当前状态
     * @param param
     * @return 重复签到时SignResult信息：success=false,message=SignCenterExCode.REPLAY_SUBMIT，logId=logId
     */
    ReSignResultDto reSign(SignRequestParam param) throws BizException;

    /**
     * 更新签到状态，签到状态为成功时更新签到统计表tb_sign_statics
     * @param logId
     * @param signStatus
     * @throws BizException 已达到终态的记录不可变更状态，抛异常，code=SignCenterExCode.REPLAY_SUBMIT
     */
    Boolean updateSignLogStatus(Long logId, SignStatusEnum signStatus, String message) throws BizException;

    /**
     * 根据时间间隔查询签到记录
     * @param param
     * @return
     */
    List<SignLogDto> findByDateInterval(SignLogQueryParam param);

    /**
     * 更新签到记录信息
     *
     * @param signLogDto
     * @return
     */
    Integer updateSignLog(SignLogDto signLogDto);

}
