package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignRecordDto;

/**
 * 签到记录service
 * Created by fangdong on 2018/06/20
 */
@AdvancedFeignClient
public interface RemoteSignRecordService {

    /**
     * 获取签到统计
     * @param consumerId
     * @return
     */
    SignRecordDto findByConsumerId(Long consumerId);

    /**
     * 新增签到统计
     * @param record
     * @return
     */
    Long insert(SignRecordDto record);

    /**
     * 更新签到统计
     * @param record
     * @return
     */
    Integer update(SignRecordDto record);

}
