package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignInfoDto;
import cn.com.duiba.sign.center.api.dto.SignStaticsDto;
import cn.com.duiba.sign.center.api.params.SignInfoQueryParam;
import cn.com.duiba.sign.center.api.params.SignStaticsQueryParam;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
@AdvancedFeignClient
public interface RemoteSignStaticsService {
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param param
     * @return
     */
    SignStaticsDto findSignStaticsByUK(SignStaticsQueryParam param);


    /**
     * 获取用户当前签到信息
     * @param param
     * @return
     */
    SignInfoDto getSignInfoByConsumer(SignInfoQueryParam param);
}
