/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.enums.creditssign;

import cn.com.duiba.sign.center.api.dto.SignRewardRuleDto;
import cn.com.duiba.sign.center.api.dto.SignRewardRuleItemDto;
import cn.com.duiba.sign.center.api.exception.SignCenterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public enum SignRewardTypeEnum {
    CONTINUE(1, "\u6769\u70b5\u753b\u6fc2\u6827\u59f3"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay > circle ? circle : continueDay;
            return rewardRule.getItems().get(index - 1);
        }
    }
    ,
    CIRCLE(2, "\u935b\u3126\u6e61\u6fc2\u6827\u59f3"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay % circle;
            index = index == 0 ? circle : index;
            return rewardRule.getItems().get(index - 1);
        }
    }
    ,
    ACCUMULATE(3, "\u7ef1\ue21d\ue178\u6fc2\u6827\u59f3"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            for (SignRewardRuleItemDto item : rewardRule.getItems()) {
                if (item.getDays() == null || !Objects.equals(item.getDays(), continueDay)) continue;
                return item;
            }
            return new SignRewardRuleItemDto();
        }
    }
    ,
    SPEC_DAY(4, "\u9417\u89c4\u7569\u93c3\u30e6\u6e61\u6fc2\u6827\u59f3"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            return new SignRewardRuleItemDto();
        }
    };

    private Integer code;
    private String desc;
    private static Map<Integer, SignRewardTypeEnum> typeMap;

    public static SignRewardTypeEnum getByCode(Integer type) {
        return typeMap.get(type);
    }

    private SignRewardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public SignRewardRuleItemDto getRuleItem(Integer continueDay, SignRewardRuleDto rewardRule) {
        if (continueDay < 0 || rewardRule == null) {
            throw new SignCenterException("\u9359\u509b\u669f\u95c8\u70b4\u7876");
        }
        if (!Boolean.TRUE.equals(rewardRule.getOpen()) || CollectionUtils.isEmpty(rewardRule.getItems())) {
            return new SignRewardRuleItemDto();
        }
        return this.getRuleItemSub(continueDay, rewardRule);
    }

    protected abstract SignRewardRuleItemDto getRuleItemSub(int var1, SignRewardRuleDto var2);

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        typeMap = new HashMap<Integer, SignRewardTypeEnum>();
        for (SignRewardTypeEnum rwType : SignRewardTypeEnum.values()) {
            typeMap.put(rwType.getCode(), rwType);
        }
    }
}

