/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.enums.creditssign;

import cn.com.duiba.sign.center.api.dto.SignActivityConfigDto;
import cn.com.duiba.sign.center.api.dto.SignRuleConfigDto;
import cn.com.duiba.sign.center.api.enums.creditssign.CustomCircleTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.DateUnit;
import cn.com.duiba.sign.center.api.exception.SignCenterException;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum SignTypeEnum {
    CONTINUE(0, "\u6769\u70b5\u753b\u7edb\u60e7\u57cc"){

        @Override
        public Calendar getCirStartDate(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(signInfo.signDate);
            calendar.add(5, 1 - this.getCircleDays(signActConfig, signInfo));
            return calendar;
        }

        @Override
        public Calendar getCirEndDate(Calendar cirStartDate, SignActivityConfigDto signActConfig, SignInfo signInfo) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(signInfo.signDate);
            return calendar;
        }

        @Override
        public Integer getCircleDays(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            return DateUnit.MONTH.getDays();
        }

        @Override
        public Integer getContinueDayInCircle(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            return signInfo.cntDaysAfterSigned;
        }
    }
    ,
    CIRCLE(1, "\u6769\u70b5\u753b\u935b\u3126\u6e61\u7edb\u60e7\u57cc"){

        @Override
        public Calendar getCirStartDate(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(signInfo.signDate);
            calendar.add(5, 1 - this.getContinueDayInCircle(signActConfig, signInfo));
            return calendar;
        }

        @Override
        public Calendar getCirEndDate(Calendar cirStartDate, SignActivityConfigDto signActConfig, SignInfo signInfo) {
            Calendar cirEndDate = Calendar.getInstance();
            cirEndDate.setTime(cirStartDate.getTime());
            cirEndDate.add(5, this.getCircleDays(signActConfig, signInfo) - 1);
            return cirEndDate;
        }

        @Override
        public Integer getContinueDayInCircle(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            int cirDays = this.getCircleDays(signActConfig, signInfo);
            int days = signInfo.cntDaysAfterSigned % cirDays;
            if (days == 0) {
                days = cirDays;
            }
            return days;
        }

        @Override
        public Integer getCircleDays(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            SignRuleConfigDto ruleConfig = signActConfig.getSignRule();
            int cirDays = 1;
            if (ruleConfig.getCusCirDays() != null) {
                cirDays = ruleConfig.getCusCirDays();
            }
            return cirDays;
        }
    }
    ,
    CUSTOM_CIRCLE(4, "\u9477\ue044\u757e\u6d94\u590a\u61c6\u93c8\ufffd"){

        @Override
        public Calendar getCirStartDate(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            SignRuleConfigDto ruleConfig = signActConfig.getSignRule();
            Calendar cusCirStart = Calendar.getInstance();
            cusCirStart.setTime(ruleConfig.getCusCirStart());
            Calendar startDate = Calendar.getInstance();
            startDate.setTime(signInfo.signDate);
            if (CustomCircleTypeEnum.FIXED_DAYS.equals((Object)ruleConfig.getCusCirType())) {
                int cirNum = (DateUtils.daysBetween((Date)cusCirStart.getTime(), (Date)signInfo.signDate) + 1) % ruleConfig.getCusCirDays();
                if (cirNum == 0) {
                    startDate.add(5, 1 - ruleConfig.getCusCirDays());
                } else {
                    startDate.add(5, 1 - cirNum);
                }
            } else if (CustomCircleTypeEnum.MONTH.equals((Object)ruleConfig.getCusCirType())) {
                startDate.set(5, cusCirStart.get(5));
                int dayGap = signInfo.signDateCalendar.get(5) - cusCirStart.get(5);
                if (dayGap < 0) {
                    startDate.add(2, -1);
                }
            }
            return startDate;
        }

        @Override
        public Calendar getCirEndDate(Calendar cirStartDate, SignActivityConfigDto signActConfig, SignInfo signInfo) {
            SignRuleConfigDto ruleConfig = signActConfig.getSignRule();
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(cirStartDate.getTime());
            if (CustomCircleTypeEnum.FIXED_DAYS.equals((Object)ruleConfig.getCusCirType())) {
                endDate.add(5, ruleConfig.getCusCirDays() - 1);
            } else if (CustomCircleTypeEnum.MONTH.equals((Object)ruleConfig.getCusCirType())) {
                endDate.add(5, cirStartDate.getActualMaximum(5) - 1);
            }
            return endDate;
        }

        @Override
        public Integer getCircleDays(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            SignRuleConfigDto ruleConfig = signActConfig.getSignRule();
            if (CustomCircleTypeEnum.FIXED_DAYS.equals((Object)ruleConfig.getCusCirType())) {
                return ruleConfig.getCusCirDays();
            }
            if (CustomCircleTypeEnum.MONTH.equals((Object)ruleConfig.getCusCirType())) {
                return this.getCirStartDate(signActConfig, signInfo).getActualMaximum(5);
            }
            throw new SignCenterException("\u6d93\u5d86\u656e\u93b8\u4f7a\u6b91\u9477\ue044\u757e\u6d94\u590a\u61c6\u93c8\u71ba\u88ab\u9368\ufffd, cusCirType=" + (Object)((Object)ruleConfig.getCusCirType()));
        }

        @Override
        public Integer getContinueDayInCircle(SignActivityConfigDto signActConfig, SignInfo signInfo) {
            Calendar cirStartDate = this.getCirStartDate(signActConfig, signInfo);
            int days = DateUtils.daysBetween((Date)cirStartDate.getTime(), (Date)signInfo.signDate) + 1;
            int continueDay = signInfo.cntDaysAfterSigned;
            if (continueDay >= days) {
                continueDay = days;
            }
            return continueDay;
        }
    };

    private static Map<Integer, SignTypeEnum> typeEnumMap;
    private Integer code;
    private String desc;

    public static SignTypeEnum getByCode(int code) {
        SignTypeEnum type = typeEnumMap.get(code);
        if (type == null) {
            throw new SignCenterException("\u6d93\u5d86\u656e\u93b8\u4f7a\u6b91\u7edb\u60e7\u57cc\u7eeb\u8bf2\u7037");
        }
        return type;
    }

    private SignTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public abstract Calendar getCirStartDate(SignActivityConfigDto var1, SignInfo var2);

    public abstract Calendar getCirEndDate(Calendar var1, SignActivityConfigDto var2, SignInfo var3);

    public abstract Integer getCircleDays(SignActivityConfigDto var1, SignInfo var2);

    public abstract Integer getContinueDayInCircle(SignActivityConfigDto var1, SignInfo var2);

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        typeEnumMap = new HashMap<Integer, SignTypeEnum>();
        for (SignTypeEnum typeEnum : SignTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static class SignInfo {
        private Calendar signDateCalendar;
        private Date signDate;
        private Integer cntDaysAfterSigned;

        public SignInfo(Date signDate, int cntDaysAfterSigned) {
            this.signDate = signDate;
            this.signDateCalendar = Calendar.getInstance();
            this.signDateCalendar.setTime(signDate);
            this.cntDaysAfterSigned = cntDaysAfterSigned;
        }

        public Calendar getSignDateCalendar() {
            return this.signDateCalendar;
        }

        public Date getSignDate() {
            return this.signDate;
        }

        public Integer getCntDaysAfterSigned() {
            return this.cntDaysAfterSigned;
        }
    }
}

