package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/5/14
 * @description:宠物道具状态
 */
public enum PetToyStatusEnum {
    PET_TOY_STATUS_PREPARE(0,"处理中"),
    PET_TOY_STATUS_USABLE(1,"可使用"),
    PET_TOY_STATUS_USED(2,"已使用")
    ;
    private String desc;
    private int code;

    PetToyStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,PetToyStatusEnum> typeMap = new HashMap<>();
    static{
        for(PetToyStatusEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PetToyStatusEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            throw new SignCenterException("不支持的宠物道具状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
