package cn.com.duiba.sign.center.api.remoteservice.signcontract;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignContractJoinStaticsDto;
import cn.com.duiba.sign.center.api.dto.SignContractBetDto;
import cn.com.duiba.sign.center.api.dto.SignContractIssueDto;
import cn.com.duiba.sign.center.api.dto.SignContractLogDto;
import cn.com.duiba.sign.center.api.params.SignContractBetUKParam;
import cn.com.duiba.sign.center.api.params.SignContractGetWardParam;
import cn.com.duiba.sign.center.api.params.SignContractIssueUKParam;
import cn.com.duiba.sign.center.api.params.SignContractJoinParam;
import cn.com.duiba.sign.center.api.params.SignContractLogUKParam;
import cn.com.duiba.sign.center.api.params.SignContractSignParam;

import java.util.List;

/**
 * Created by xiaoxuda on 2018/6/6.
 */
@AdvancedFeignClient
public interface RemoteSignContractMobileService {

    Integer getRewardCount(SignContractBetUKParam param);

    /**
     * 通过唯一键查询打卡情况
     * @return
     */
    SignContractLogDto findByUK(SignContractLogUKParam param);

    /**
     * 查询本期次当天打卡成功人数
     */
    Long countDaySuccByIssue(Long issueId);
    /**
     *
     */
    /**
     * 查询最近的一次参与记录
     * @param param
     * @return
     */
    SignContractBetDto findLastBet(SignContractBetUKParam param);
    /**
     * 查询给定活动下未完成的契约
     * @param param
     * @return
     */
    SignContractBetDto findUndoneBet(SignContractBetUKParam param);

    /**
     * 查询期次信息
     * @return
     */
    SignContractIssueDto findIssueById(Long issueId);

    /**
     * 批量查询期次信息
     * @param issueIds
     * @return
     */
    List<SignContractIssueDto> findIssueByIds(List<Long> issueIds);

    /**
     * 查询所有参与记录
     * @param param
     * @return
     */
    List<SignContractBetDto> findJoinedByAct(SignContractBetUKParam param);

    /**
     * 分页查询参与记录,参与时间倒序
     * @param param
     * @return
     */
    List<SignContractBetDto> pageFindJoinedByAct(SignContractBetUKParam param);

    /**
     * 统计所有参与的期次数量
     * @param param
     * @return
     */
    Integer countJoinedByAct(SignContractBetUKParam param);

    /**
     * 查询已完成待领奖的契约
     * @param param
     * @return
     */
    List<SignContractBetDto> findDoneBet(SignContractBetUKParam param);

    /**
     * 参与契约, 如果有未完成契约且契约已过期或已中断不可补救，则直接将此类契约置为失败，之后再新建契约
     * @param param
     * @return
     */
    SignContractBetDto joinContract(SignContractJoinParam param) throws BizException;

    /**
     * 打卡
     * @return 打卡记录ID
     * @exception
     */
    Long doSign(SignContractSignParam param) throws BizException;

    /**
     * 领奖
     * @param param
     * @return
     */
    Boolean getReward(SignContractGetWardParam param) throws BizException;

    /**
     * 查询给定活动下今日可参加的期次
     * @param actId
     * @return
     */
    SignContractIssueDto getTodayIssue(Long actId);

    /**
     * 根据契约ID查询
     * @param contractId
     * @return
     */
    SignContractBetDto findContractBetById(Long contractId);

    /**
     * 统计契约活动的历史累积参与数据
     * @param actId
     * @return
     */
    SignContractJoinStaticsDto countContractBetUser(Long appId, Long actId);

    /**
     * 今日开奖的获奖名单（200个）
     * @param issueId
     * @return 获奖用户ID
     */
    List<Long> getWinnersWaitRewardByIssueLimit200(Long issueId);

    /**
     * 根据唯一键查询期次信息
     * @param param
     * @return
     */
    SignContractIssueDto findIssueByUK(SignContractIssueUKParam param);
}
