package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.PetReceivedFoodDto;
import cn.com.duiba.sign.center.api.dto.SignPetFeedRankDto;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * Created by Liugq on 2018/7/11.
 * 宠物附加功能：
 */
@AdvancedFeignClient
public interface RemoteSignPetAdditionService {

    /**
     * 宠物喂食排行榜（群养）
     * @param petId
     * @param consumerId
     * @param topNum 排行榜显示个数
     * @return 返回top n list + 当前用户的排行信息
     * 例： 查询top10 会返回size 11 的list，当前用户信息放在list最后
     */
    List<SignPetFeedRankDto> getPetFeedRank(Long petId, Long consumerId, Integer topNum);

    /**
     * 当日待领取粮食堆
     * @param consumerId
     * @return
     */
    List<PetReceivedFoodDto> selectDayReceivedFood(Long consumerId);

    /**
     * 领取待领取粮食
     * @param appId
     * @param partnerUserId
     * @param activityId
     * @param foodId
     * @throws BizException
     */
    void collectFood(Long appId,String partnerUserId,Long activityId,Long foodId) throws BizException;

    /**
     * 插入当天待收取粮食（存在则修改）
     * @param dto
     * @return
     */
    Long upsertFoodForDay(PetReceivedFoodDto dto);

}
