package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.signpet.ExchangeTypeEnum;
import cn.com.duiba.sign.center.api.enums.signpet.ToySubTypeEnum;
import cn.com.duiba.sign.center.api.enums.signpet.ToyTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description:
 */
public class SignPetActivityToyDto implements Serializable{
    private static final long serialVersionUID = -4528956522703113398L;
    /**
     * id
     **/
    private Long id;
    /**
     * 活动ID
     **/
    private Long activityId;
    /**
     * 1-状态类 2-装饰类 3-功能类 4-食物类 5-玩具类
     **/
    private ToyTypeEnum toyType;
    /**
     * 道具标识
     */
    private String identifier;
    /**
     * 道具名称
     **/
    private String toyName;
    /**
     * 市场价值（分）
     **/
    private Integer facePrice;
    /**
     * 使用时是否有状态(0-否1-是)
     **/
    private Boolean withStatus;
    /**
     * 持续时间(分钟)
     **/
    private Integer duration;
    /**
     * 开启状态(0-否，1-是)
     **/
    private Boolean openStatus;
    /**
     * 道具功能描述
     */
    private String description;
    /**
     * 删除状态
     */
    private Boolean deleted;
    /**
     * 1-签到星座 2-日历签到 4-宠物签到 5-契约签到 6-外来宠物签到
     **/
    private SignActivityTypeEnum actType;
    /**
     * 道具兑换方式：1-积分 2-粮食
     **/
    private ExchangeTypeEnum exchangeType;
    /**
     * 道具购买开启的经验值限制
     **/
    private Integer purchaseExpLimit;
    /**
     * 是否可重复购买 0-否 1-是
     **/
    private Boolean canRepeatePurchase;
    /**
     * 道具图片
     **/
    private String imgUrl;
    /**
     * 附加参数存储（个性化）
     **/
    private String extraJson;
    /**
     * 装饰道具的类型：1.眼睛 2.头部 3.上身 4.下身 5.脚
     **/
    private ToySubTypeEnum toySubType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getToyName() {
        return toyName;
    }

    public void setToyName(String toyName) {
        this.toyName = toyName;
    }

    public Integer getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Boolean getWithStatus() {
        return withStatus;
    }

    public void setWithStatus(Boolean withStatus) {
        this.withStatus = withStatus;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Boolean getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Boolean openStatus) {
        this.openStatus = openStatus;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ToyTypeEnum getToyType() {
        return toyType;
    }

    public void setToyType(ToyTypeEnum toyType) {
        this.toyType = toyType;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public SignActivityTypeEnum getActType() {
        return actType;
    }

    public void setActType(SignActivityTypeEnum actType) {
        this.actType = actType;
    }

    public ExchangeTypeEnum getExchangeType() {
        return exchangeType;
    }

    public void setExchangeType(ExchangeTypeEnum exchangeType) {
        this.exchangeType = exchangeType;
    }

    public Integer getPurchaseExpLimit() {
        return purchaseExpLimit;
    }

    public void setPurchaseExpLimit(Integer purchaseExpLimit) {
        this.purchaseExpLimit = purchaseExpLimit;
    }

    public Boolean getCanRepeatePurchase() {
        return canRepeatePurchase;
    }

    public void setCanRepeatePurchase(Boolean canRepeatePurchase) {
        this.canRepeatePurchase = canRepeatePurchase;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public ToySubTypeEnum getToySubType() {
        return toySubType;
    }

    public void setToySubType(ToySubTypeEnum toySubType) {
        this.toySubType = toySubType;
    }
}
