package cn.com.duiba.sign.center.api.enums.signpet;


import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/4/25
 * @description:
 */
public enum PetFeedTypeEnum {

    PET_FEED_TYPE_PRIVATE(1,"私人"),
    PET_FEED_TYPE_GROUP(2,"群体")
    ;
    private String desc;
    private int code;

    PetFeedTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,PetFeedTypeEnum> typeMap = new HashMap<>();
    static{
        for(PetFeedTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PetFeedTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            throw new SignCenterException("不支持的喂养状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
