package cn.com.duiba.sign.center.api.remoteservice.signfloor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.sign.center.api.dto.SignFloorResultDto;
import cn.com.duiba.sign.center.api.params.SignLogParam;
import cn.com.duiba.sign.center.api.params.SignParam;


/**
 * 签到楼层service
 * Created by fangdong on 2018/6/12
 */
@AdvancedFeignClient
public interface RemoteSignFloorService {

    /**
     * 获取签到信息
     * @param cid
     * @return
     */
    ConsumerSignInfoDto getSignInfo(Long cid) throws BizException;

    /**
     * 创建签到记录
     * @param param
     * @return
     */
    Long createSignLog(SignLogParam param) throws BizException;


    /**
     * 用户签到
     * @param param
     * @return
     */
    SignFloorResultDto signIn(SignParam param) throws BizException;

}
