package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityStatusEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignRewardTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;
import cn.com.duiba.sign.center.api.exception.SignCenterException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/20.
 */
public class SignActivityDto implements Serializable {
    private static final long serialVersionUID = 1752779918200677322L;

    public static final Integer AppDirectSwitch = 1;
    public static final Integer DeveloperBlackSwitch = 2;

    /**
     * extra内容KEY
     */
    public static final String KEY_SIGNRULE = "signRule";
    //日历之前的日期
    @Deprecated
    public static final String KEY_BEFOREDATE = "beforeDate";
    @Deprecated
    public static final String KEY_AFTERDATE = "afterDate";
    //是否开启补签
    @Deprecated
    public static final String KEY_RE_SIGN_OPEN = "openReSign";
    //补签规则
    public static final String KEY_RE_SIGN_RULE = "reSignRule";
    //是否开启累计签到奖励
    @Deprecated
    public static final String KEY_ACCUMULATE_OPEN = "acmOpen";
    //累积签到规则
    @Deprecated
    public static final String KEY_ACCUMULATE_RULE = "acmRule";
    //奖励规则配置
    public static final String KEY_REWARD_CONFIG = "rwConfig";

    private Long id;
    /**
     * 签到活动标题
     */
    private String title;

    /**
     * 活动简介
     */
    private String intro;

    /**
     * 签到活动类型
     */
    private SignActivityTypeEnum signType;

    /**
     * 描述
     */
    private String description;

    /**
     * 活动状态
     */
    private SignActivityStatusEnum status;
    /**
     * 功能开关，位运算保存
     */
    private Integer switches;
    /**
     * 预览图
     */
    private String previewImage;
    /**
     * 删除状态
     */
    private Boolean deleted;

    /**
     * 额外字段，存储签到配置信息，json结构，新数据必须在DTO中定义key
     */
    private JSONObject extra;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntro () {
        return intro;
    }

    public void setIntro (String intro) {
        this.intro = intro;
    }

    public SignActivityTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignActivityTypeEnum signType) {
        this.signType = signType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SignActivityStatusEnum getStatus() {
        return status;
    }

    public void setStatus(SignActivityStatusEnum status) {
        this.status = status;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public String getPreviewImage() {
        return previewImage;
    }

    public void setPreviewImage(String previewImage) {
        this.previewImage = previewImage;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public void putToExtra(String key, Object val) {
        if (extra == null) {
            extra = new JSONObject();
        }
        extra.put(key, val);
    }

    public void removeFromExtra(String key) {
        if (extra == null) {
            return;
        }
        extra.remove(key);
    }

    public Object getFromExtra(String key) {
        if (extra == null) {
            return null;
        }
        return extra.get(key);
    }

    /**
     * 提取签到规则信息
     * @return
     */
    public SignRuleConfigDto getSignRuleConfig() {
        if (extra == null) {
            return null;
        }
        SignRuleConfigDto signRule = extra.getObject(KEY_SIGNRULE, SignRuleConfigDto.class);
        if(signRule == null){
            signRule = new SignRuleConfigDto();
        }
        if(SignTypeEnum.CIRCLE.equals(signRule.getType()) && signRule.getCusCirDays() == null){//旧数据兼容设置
            signRule.setCusCirDays(JSONArray.parseArray(extra.getJSONObject(KEY_SIGNRULE)
                    .getString(SignRuleConfigDto.KEY_ITEMS)).size());
        }
        return signRule;
    }

    /**
     * 提取补签规则信息
     * @return
     */
    public ReSignRuleConfigDto getReSignRuleConfig() {
        if (extra == null) {
            return null;
        }
        ReSignRuleConfigDto reSignRuleConfig= extra.getObject(KEY_RE_SIGN_RULE, ReSignRuleConfigDto.class);
        if(reSignRuleConfig == null){
            reSignRuleConfig = new ReSignRuleConfigDto();
        }else if(extra.getBoolean(KEY_RE_SIGN_OPEN) != null){//兼容旧数据设置
            reSignRuleConfig.setOpen(extra.getBoolean(KEY_RE_SIGN_OPEN));
        }
        return reSignRuleConfig;
    }

    /**
     * 签到奖励配置
     * @return
     */
    public SignRewardConfigDto getSignRewardConfig(){
        if (extra == null) {
            return new SignRewardConfigDto();
        }
        SignRewardConfigDto rewardConfig = extra.getObject(KEY_REWARD_CONFIG, SignRewardConfigDto.class);
        if(rewardConfig == null){
            rewardConfig = new SignRewardConfigDto();
        }
        if(!MapUtils.isEmpty(rewardConfig.getRwRules())){
            return rewardConfig;
        }

        SignRuleConfigDto signRule = getSignRuleConfig();
        //兼容常规奖励旧数据
        SignRewardRuleDto rewardRule = new SignRewardRuleDto();
        rewardRule.setOpen(true);
        if(SignTypeEnum.CONTINUE.equals(signRule.getType())){
            rewardRule.setRwType(SignRewardTypeEnum.CONTINUE);
        }else if(SignTypeEnum.CIRCLE.equals(signRule.getType())){
            rewardRule.setRwType(SignRewardTypeEnum.CIRCLE);
        }else if(SignTypeEnum.CUSTOM_CIRCLE.equals(signRule.getType())){
            rewardRule.setRwType(SignRewardTypeEnum.CIRCLE);
        }
        rewardRule.setItems(JSONArray.parseArray(extra.getJSONObject(KEY_SIGNRULE).getString(SignRuleConfigDto.KEY_ITEMS),
                SignRewardRuleItemDto.class));
        rewardConfig.putToRwRules(rewardRule);
        //兼容累计签到旧数据
        SignRewardRuleDto acmRewardRule = new SignRewardRuleDto();
        acmRewardRule.setOpen(Boolean.TRUE.equals(extra.getBoolean(KEY_ACCUMULATE_OPEN)));
        acmRewardRule.setRwType(SignRewardTypeEnum.ACCUMULATE);
        if(acmRewardRule.getOpen()) {
            List<SignRewardRuleItemDto> acmReward = JSONArray.parseArray(extra.getString(KEY_ACCUMULATE_RULE),
                    SignRewardRuleItemDto.class);
            if(CollectionUtils.isEmpty(acmReward)){
                acmRewardRule.setOpen(false);
            }else{
                acmRewardRule.setItems(acmReward);
            }
        }
        rewardConfig.putToRwRules(acmRewardRule);
        return rewardConfig;
    }

    /**
     * 数据查询间隔，直接废弃不再使用
     * @param key
     * @return
     */
    public Integer getDateArea(String key) {
        if (extra == null) {
            return 14;
        }
        if (!key.equals(KEY_BEFOREDATE) && !key.equals(KEY_AFTERDATE)) {
            throw new SignCenterException("查询之前、之后的key值不正确");
        }
        return extra.getInteger(key);
    }

}
