package cn.com.duiba.sign.center.api.enums.signcontract;

/**
 * 投注方式
 * Created by xiaoxuda on 2018/6/5.
 */
public enum SignBetTypeEnum {
    CUSTOM(1, "自由额度"),
    SOLID(2, "固定额度");

    private Integer code;
    private String desc;

    SignBetTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static SignBetTypeEnum getByCode(Integer code){
        if(code == null){
            return null;
        }
        for(SignBetTypeEnum type : values()){
            if(type.getCode().equals(code)){
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
