package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/5/17
 * @description:宠物带回礼物类型
 */
public enum PetGiftTypeEnum {
    PET_GIFT_TYPE_CUSTOM(1,"用户自定义"),
    PET_GIFT_TYPE_FOOD(2,"食物")
    ;
    private String desc;
    private int code;

    PetGiftTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,PetGiftTypeEnum> typeMap = new HashMap<>();
    static{
        for(PetGiftTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PetGiftTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            throw new SignCenterException("不支持的宠物道具状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
