package cn.com.duiba.sign.center.api.enums.signpet;

import java.util.HashMap;
import java.util.Map;

public enum PetLevelEnum {
    PET_LEVEL_TYPE_OEDI(0,"普通"),
    PET_LEVEL_TYPE_RARE(1,"稀有")
    ;
    private int code;
    private String desc;
    PetLevelEnum(int code,String desc){
        this.code=code;
        this.desc=desc;
    }
    private static Map<Integer,PetLevelEnum>typeMap=new HashMap<>();
    static {
        for (PetLevelEnum petLevelEnum:values()){
            typeMap.put(petLevelEnum.getCode(),petLevelEnum);
        }
    }
    public static PetLevelEnum getEnumByCode(Integer code){
        if(code==null){
            return null;
        }
        if(!typeMap.containsKey(code)){
            return null;
        }
        return typeMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
