package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignWanderRecordDto;

import java.util.List;

/**
 * Created by Liugq on 2018/8/8.
 * 外来宠物C端接口
 */
@AdvancedFeignClient
public interface RemoteSignWanderMobileService {

    /**
     * 查询最近的外来宠物到访记录
     * @param actId
     * @param consumerId
     * @param showNum  展示条数
     * @return
     */
    List<SignWanderRecordDto> selectWanderRecord(Long actId,Long consumerId,Integer showNum);

    /**
     * 是否存在未读取的记录
     * @param actId
     * @param consumerId
     * @return
     */
    Boolean exsistNotReadRecord(Long actId,Long consumerId);

    /**
     * 是否存在未领取的礼物记录
     * @param actId
     * @param consumerId
     * @return
     */
    Boolean exsistNotAcceptRecord(Long actId,Long consumerId);

    /**
     * 礼物记录-领取礼物
     * @param recordId 记录主键ID
     */
    void collectGiftRecord(Long recordId);

}
