package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.PetCurrentStatusDto;
import cn.com.duiba.sign.center.api.dto.SignPetStatusDto;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetStatusEnum;

import java.util.List;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description: 签到宠物状态（管理后台）
 */
@AdvancedFeignClient
public interface RemoteSignPetStatusService {

    /**
     * 获取宠物当期状态
     * @param petId
     * @return
     */
    PetCurrentStatusDto getPetStatus(long petId);

    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return 状态ID
     */
    long insert(SignPetStatusDto dto);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    int updateById(SignPetStatusDto dto);

    /**
     * 根据状态分类查询状态列表
     * @param activityId
     * @param status: 状态值
     * @return
     */
    SignPetStatusDto getStatusByActAndCodeWithCache(long activityId, SignPetStatusEnum status);

    /**
     * 查询活动的有效状态配置
     * @param actId
     * @return
     */
    List<SignPetStatusDto> getStatusByActId(long actId);
}
