package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.FeedPetResultDto;
import cn.com.duiba.sign.center.api.dto.SignPetDto;
import cn.com.duiba.sign.center.api.enums.signpet.PetFeedTypeEnum;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description: 签到宠物相关服务
 */
@AdvancedFeignClient
public interface RemoteSignPetService {

    /**
     * 宠物是否吃饱的状态
     * @return
     */
    boolean fullState(long petId);

    /**
     * 宠物喂食
     * @param petId 宠物id
     * @param consumerId 用户id
     * @param feedNum (如果喂食时明确知道喂食数量，则传喂食数量 否则传饲养员剩余粮食量，实际处理已设置的每次限制喂食量为准)
     */
    FeedPetResultDto feedPet(long appId,long petId, long consumerId,String partnerUserId, int feedNum)throws BizException;

    /**
     * 查询用户的宠物
     * @param activityId
     * @param ownerId
     * @return
     */
     SignPetDto findByActIdAndOwner(long activityId, String ownerId);

    /**
     * 查询宠物 不存在在插入数据
     * @param dto
     * @param appId
     * @param partnerUserId
     * @return
     */
    SignPetDto findOrAdoptePet(SignPetDto dto,long appId,long consumerId,String partnerUserId);

    /**
     * 主键查询
     * @param id
     * @return
     */
    SignPetDto findById(long id);

}
