package cn.com.duiba.sign.center.api.enums.signcontract;

import cn.com.duiba.sign.center.api.exception.SignCenterException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/8/28.
 * 周期类型
 */
public enum RankPeriodEnum {
    PERIOD_NONE(0, "关闭排行榜"),
    PERIOD_WEEK(1, "周排行"),
    PERIOD_MONTH(2, "月排行"),;
    private String desc;
    private int code;

    RankPeriodEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, RankPeriodEnum> typeMap = new HashMap<>();

    static {
        for (RankPeriodEnum typeEnum : values()) {
            typeMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     *
     * @param code
     * @return
     */
    public static RankPeriodEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        if (!typeMap.containsKey(code)) {
            throw new SignCenterException("不支持的喂养状态，status=" + code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
