package cn.com.duiba.sign.center.api.enums.signpet;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/8/7.
 */
public enum WanderPetRecordTypeEnum {

    WANDER_PET_RECORD_TYPE_VISIT(1,"状态类"),
    WANDER_PET_RECORD_TYPE_GIFT(2,"礼物")
    ;
    private String desc;
    private int code;

    WanderPetRecordTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,WanderPetRecordTypeEnum> typeMap = new HashMap<>();
    static{
        for(WanderPetRecordTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static WanderPetRecordTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            return null;
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
