package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignRemindConfigDto;
import cn.com.duiba.sign.center.api.dto.SignRemindResultDto;
import cn.com.duiba.sign.center.api.params.SignActivityKeyParam;

/**
 * Created by fangdong on 2018/08/15
 */
@AdvancedFeignClient
public interface RemoteSignRemindService {

    /**
     * 发送签到提醒
     *
     * @param configId 配置id
     * @return
     * @throws BizException
     */
    SignRemindResultDto send(Long configId) throws BizException;

    /**
     * 查询签到提醒配置
     *
     * @param param param
     * @return
     * @throws BizException
     */
    SignRemindConfigDto getByKey(SignActivityKeyParam param) throws BizException;

}
