package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignPetLevelDto;

import java.util.List;

/**
 * Created by fangdong on 2018/07/11
 */
@AdvancedFeignClient
public interface RemoteSignPetLevelService {

    /**
     * 插入
     * @param level
     * @return
     */
    Long save(SignPetLevelDto level);

    /**
     * 更新
     * @param level
     * @return
     */
    Integer update(SignPetLevelDto level);

    /**
     * 批量保存
     * @param levelList
     * @return
     */
    Integer saveList(List<SignPetLevelDto> levelList);

    /**
     * 根据活动id获取list
     * @param activityId
     * @return
     */
    List<SignPetLevelDto> listByActivityId(Long activityId);

    /**
     * 获取等级信息
     * @param level
     * @return
     */
    SignPetLevelDto getLevel(Long activityId, Integer level);

}
