package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignInfoDto;
import cn.com.duiba.sign.center.api.dto.SignStaticsDto;
import cn.com.duiba.sign.center.api.params.*;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
@AdvancedFeignClient
public interface RemoteSignStaticsService {
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param param
     * @return
     */
    SignStaticsDto findSignStaticsByUK(SignStaticsQueryParam param);


    /**
     * 获取用户当前签到信息
     * @param param
     * @return
     */
    SignInfoDto getSignInfoByConsumer(SignInfoQueryParam param);

    /**
     * 签到累计积分
     * @param consumerId consumerId
     * @return 签到累计积分
     */
    Integer getSignTotalCredits(SignCreditsQueryParam param) throws BizException;

    /**
     * 分页查询
     * @param param
     * @param query
     * @return
     */
    Page<Long> page(SignStaticsQueryParam param, PageParams query) throws BizException;
}
