package cn.com.duiba.sign.center.api.util;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * 生成的key前缀为：SIGNCENTER_K001_
 * <p>
 * Created by liugq on 2018/4/25
 */
public enum RedisKeyFactory {

    K001("宠物当前状态"),
    K002("签到皮肤"),
    K003("签到活动"),
    K004("签到入库"),
    K005("签到养成活动"),
    K006("宠物缓存"),
    K007("养成活动配置状态缓存"),
    K008("宠物吃饱状态过期时间"),
    K009("养成活动状态配置"),
    K010("签到日历每日规则"),
    K011("签到日历每日规则时间段查询"),
    K012("签到星座每日规则"),
    K013("签到星座每日规则时间段查询"),
    K014("签到皮肤模板数据缓存"),
    K015("周期内当前满前人数"),
    K016("宠物外出奖励"),
    K017("更新签到数据锁key"),
    K018("签到契约打卡"),
    K019("创建契约签到期次"),
    K020("签订契约"),
    K021("契约活动期次成功签到人数"),
    K022("签到楼层配置"),
    K023("signRecord切读开关"),
    K024("用户当天投食次数"),
    K025("宠物投食群排行榜"),
    K027("契约签到收益排行榜"),
    K029("未签到用户uid集合"),
    K030("契约签到期次当天打卡人押注总额"),
    K031("外出宠物活动配置"),
    K032("契约签到打卡次数排行榜"),
    K033("契约签到活动配置缓存"),
    K034("期次开奖数据查询缓存"),
    K035("契约最新一期开奖收益倍率"),
    K036("外出宠物活动用户上次访问时间"),
    K037("英语流利说答题计数器"),
    K038("英语流利说答题集合"),
    ;

    public static String generateRedisKey(RedisKeyFactory redisKeyFactory,String key){
        return redisKeyFactory.toString()+ key;
    }

    private String description;

    private RedisKeyFactory(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    /**
     * sign-center
     */
    private static final String SPACE = "SIGNCENTER";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


}
