package cn.com.duiba.sign.center.api.enums.signcontract;

/**
 * @Author leihu
 * @Description: 新增瓜分类型的枚举
 * @CreateDate: 2018/9/30 13:43
 * @UpdateUser: leihu
 * @UpdateDate: 2018/9/30 13:43
 * @UpdateRemark:
 * @Version 1.0
 */
public enum SignContractBonusTypeEnum {
    CREDITS(0, "瓜分积分"),
    CASH(1, "瓜分现金"),
    ;

    private Integer code;
    private String desc;

    SignContractBonusTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     *
     * @param code
     * @return
     */
    public static SignContractBonusTypeEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SignContractBonusTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
