package cn.com.duiba.sign.center.api.dto.signtreasure;

import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureActStatusEnum;
import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureStockWarnTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author chenxiangge
 * @Date 2019/4/25
 */
public class SignTreasureActivityDto implements Serializable {

    /**
     * 是否开启签到奖励
     */
    public static final int SIGN_FREE_GET_CODE = 1;

    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;


    /**
     * 活动开始时间（首期开始时间）
     */
    private Date actStartTime;

    /**
     *  标题
     */
    private String title;

    /**
     * 规则
     */
    private String rule;

    /**
     * 入口缩略图
     */
    private String smallImage;

    /**
     * banner图
     */
    private String bannerImage;

    /**
     * 界面配置
     */
    private String skinConfig;

    /**
     * 展示中奖轮播 0-不支持 1-支持
     */
    private Boolean showWinRecord;

    /**
     * 是否支持积分兑换 0-不支持 1-支持
     */
    private Boolean creditsSupport;

    /**
     * 单次兑换消耗积分数量
     */
    private Integer credits;

    /**
     * 购买上限
     */
    private Integer maxPurchaseAmount;

    /**
     * 是否自动续期 0-不续期，1-续期
     */
    private Boolean autoContinue;

    /**
     * 自动续期数
     */
    private Integer autoContinueCount;

    /**
     * 当前期次id
     */
    private Long currentPhaseId;

    /**
     * 当前期次序号
     */
    private Integer currentPayload;

    /**
     * 活动周期
     */
    private Integer activityCycle;

    /**
     * 结束后多久开奖（天数）
     */
    private Integer takePrizeCycle;

    /**
     * （待定）开奖时间 hh:mm格式
     */
    private String takePrizeTimeStr;

    /**
     * 库存预警类型 0-邮箱 1-手机
     */
    private SignTreasureStockWarnTypeEnum stockWarnType;

    /**
     * 库存预警发送方具体信息
     */
    private String stockWarnDetail;

    /**
     * 0-进行中 1-已结束
     */
    private SignTreasureActStatusEnum activityStatus;

    /**
     * 浮窗
     */
    private String floatingWindow;

    /**
     * 开关切换
     * 功能开关集合，通过位运算获取具体开关状态
     * 1。 签到是否免费
     */
    private Integer switchType;

    public String getFloatingWindow() {
        return floatingWindow;
    }

    public void setFloatingWindow(String floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    public Integer getSwitchType() {
        return switchType;
    }

    public void setSwitchType(Integer switchType) {
        this.switchType = switchType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getRule() {
        return rule;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setSkinConfig(String skinConfig) {
        this.skinConfig = skinConfig;
    }

    public String getSkinConfig() {
        return skinConfig;
    }

    public void setShowWinRecord(Boolean showWinRecord) {
        this.showWinRecord = showWinRecord;
    }

    public Boolean getCreditsSupport() {
        return creditsSupport;
    }

    public void setCreditsSupport(Boolean creditsSupport) {
        this.creditsSupport = creditsSupport;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setMaxPurchaseAmount(Integer maxPurchaseAmount) {
        this.maxPurchaseAmount = maxPurchaseAmount;
    }

    public Integer getMaxPurchaseAmount() {
        return maxPurchaseAmount;
    }

    public Boolean getAutoContinue() {
        return autoContinue;
    }

    public void setAutoContinue(Boolean autoContinue) {
        this.autoContinue = autoContinue;
    }

    public void setAutoContinueCount(Integer autoContinueCount) {
        this.autoContinueCount = autoContinueCount;
    }

    public Integer getAutoContinueCount() {
        return autoContinueCount;
    }

    public void setCurrentPhaseId(Long currentPhaseId) {
        this.currentPhaseId = currentPhaseId;
    }

    public Long getCurrentPhaseId() {
        return currentPhaseId;
    }

    public void setCurrentPayload(Integer currentPayload) {
        this.currentPayload = currentPayload;
    }

    public Integer getCurrentPayload() {
        return currentPayload;
    }

    public void setActivityCycle(Integer activityCycle) {
        this.activityCycle = activityCycle;
    }

    public Integer getActivityCycle() {
        return activityCycle;
    }

    public String getTakePrizeTimeStr() {
        return takePrizeTimeStr;
    }

    public void setTakePrizeTimeStr(String takePrizeTimeStr) {
        this.takePrizeTimeStr = takePrizeTimeStr;
    }

    public SignTreasureActStatusEnum getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(SignTreasureActStatusEnum activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Integer getTakePrizeCycle() {
        return takePrizeCycle;
    }

    public void setTakePrizeCycle(Integer takePrizeCycle) {
        this.takePrizeCycle = takePrizeCycle;
    }

    public SignTreasureStockWarnTypeEnum getStockWarnType() {
        return stockWarnType;
    }

    public void setStockWarnType(SignTreasureStockWarnTypeEnum stockWarnType) {
        this.stockWarnType = stockWarnType;
    }

    public String getStockWarnDetail() {
        return stockWarnDetail;
    }

    public void setStockWarnDetail(String stockWarnDetail) {
        this.stockWarnDetail = stockWarnDetail;
    }

    public Boolean getShowWinRecord() {
        return showWinRecord;
    }

    public Date getActStartTime() {
        return actStartTime;
    }

    public void setActStartTime(Date actStartTime) {
        this.actStartTime = actStartTime;
    }
}
