package cn.com.duiba.sign.center.api.enums.signcomponent;

import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

/**
 * Created by 歪大哥😁 on 2019-08-22.
 */
public enum SignToolsTypeEnum {

    SCRATCH_CARD(1, "刮刮卡"),
    LOTTERY_WHEEL(2, "摇奖机"),
    BIG_WHEEL(3, "大转盘"),
    ;

    private static final Map<Integer, SignToolsTypeEnum> ALL_MAPPING;

    static {
        Map<Integer, SignToolsTypeEnum> temp = Maps.newHashMap();
        for (SignToolsTypeEnum value : values()) {
            temp.put(value.code, value);
        }
        ALL_MAPPING = temp;
    }

    private Integer code;
    private String desc;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    SignToolsTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    @CheckForNull
    public static SignToolsTypeEnum getType(Integer code) {
        return ALL_MAPPING.get(code);
    }
}
